import pandas as pd  
from sklearn.preprocessing import StandardScaler 
import pickle 
from decision_company import read_csv_file, create_standard_scaler, fit_transform_standard_scaler
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Normalize the data  
scaler = create_standard_scaler()  
data_for_clustering_scaled = fit_transform_standard_scaler(scaler, data_for_clustering) 

print("data_for_clustering_scaled:\n", data_for_clustering_scaled)    
pickle.dump(data_for_clustering_scaled,open("./ref_result/data_for_clustering_scaled.pkl","wb"))